<?php
require_once '../includes/config.php';
require_once '../includes/db.php';
require_once '../includes/functions.php';

// Check if admin is logged in
if (!isset($_SESSION['admin_id'])) {
    redirect(APP_URL . '/admin/login.php');
}

$pageTitle = 'User Details';
$adminId = $_SESSION['admin_id'];
$error = '';

// Check if user ID is provided
if (!isset($_GET['id'])) {
    setFlashMessage('danger', 'User ID is required');
    redirect(APP_URL . '/admin/users.php');
}

$userId = (int)$_GET['id'];
$user = getUserById($userId);

// Check if user exists
if (!$user) {
    setFlashMessage('danger', 'User not found');
    redirect(APP_URL . '/admin/users.php');
}

// Get user's books
$books = $db->select("SELECT * FROM books WHERE user_id = ? ORDER BY created_at DESC", [$userId]);

// Get user's social links
$socialLinks = getSocialLinksByUserId($userId);

// Get user activity (registration date, last login, etc.)
// This would require additional tracking in your database

// Include header
include 'templates/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">User Details</h1>
    
    <div>
        <a href="<?php echo APP_URL . '/' . sanitize($user['permalink']); ?>" target="_blank" class="btn btn-primary">
            <i class="fas fa-external-link-alt"></i> View User Page
        </a>
        <a href="<?php echo APP_URL; ?>/admin/users.php" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Back to Users
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-4">
        <div class="card mb-4">
            <div class="card-header">
                <h6 class="m-0 font-weight-bold">User Information</h6>
            </div>
            <div class="card-body">
                <div class="text-center mb-4">
                    <?php if (!empty($user['profile_image'])): ?>
                        <img src="<?php echo UPLOAD_URL . $user['profile_image']; ?>" alt="<?php echo sanitize($user['username']); ?>" class="img-fluid rounded-circle" style="max-height: 150px; max-width
                        <img src="<?php echo UPLOAD_URL . $user['profile_image']; ?>" alt="<?php echo sanitize($user['username']); ?>" class="img-fluid rounded-circle" style="max-height: 150px; max-width: 150px;">
                    <?php else: ?>
                        <div class="rounded-circle bg-secondary d-flex align-items-center justify-content-center mx-auto" style="width: 150px; height: 150px;">
                            <i class="fas fa-user fa-5x text-white"></i>
                        </div>
                    <?php endif; ?>
                </div>
                
                <h5 class="text-center mb-3"><?php echo sanitize($user['username']); ?></h5>
                
                <p><strong>Email:</strong> <?php echo sanitize($user['email']); ?></p>
                <p>
                    <strong>Permalink:</strong> 
                    <a href="<?php echo APP_URL . '/' . sanitize($user['permalink']); ?>" target="_blank">
                        <?php echo sanitize($user['permalink']); ?>
                    </a>
                </p>
                
                <p><strong>Created:</strong> <?php echo date('M j, Y', strtotime($user['created_at'])); ?></p>
                <p><strong>Last Updated:</strong> <?php echo date('M j, Y', strtotime($user['updated_at'])); ?></p>
                
                <hr>
                
                <h6>Actions</h6>
                <div class="d-grid gap-2">
                    <button type="button" class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#resetPasswordModal">
                        <i class="fas fa-key"></i> Reset Password
                    </button>
                    <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#deleteUserModal">
                        <i class="fas fa-trash"></i> Delete User
                    </button>
                </div>
            </div>
        </div>
        
        <div class="card mb-4">
            <div class="card-header">
                <h6 class="m-0 font-weight-bold">Social Links</h6>
            </div>
            <div class="card-body">
                <?php if (count($socialLinks) > 0): ?>
                    <ul class="list-group">
                        <?php foreach ($socialLinks as $link): ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <i class="fab fa-<?php echo sanitize($link['platform']); ?> me-2"></i>
                                    <?php echo ucfirst(sanitize($link['platform'])); ?>
                                </div>
                                <a href="<?php echo sanitize($link['url']); ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                                    <i class="fas fa-external-link-alt"></i>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php else: ?>
                    <p class="text-muted">No social links added</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <div class="col-md-8">
        <div class="card mb-4">
            <div class="card-header">
                <h6 class="m-0 font-weight-bold">User's Books</h6>
            </div>
            <div class="card-body">
                <?php if (count($books) > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>Title</th>
                                    <th>Status</th>
                                    <th>Created</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($books as $book): ?>
                                    <tr>
                                        <td><?php echo sanitize($book['title']); ?></td>
                                        <td>
                                            <?php if ($book['is_published']): ?>
                                                <span class="badge bg-success">Published</span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary">Unpublished</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo date('M j, Y', strtotime($book['created_at'])); ?></td>
                                        <td>
                                            <a href="book-details.php?id=<?php echo $book['id']; ?>" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i> View
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <p class="text-muted">No books added by this user</p>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header">
                <h6 class="m-0 font-weight-bold">User Activity</h6>
            </div>
            <div class="card-body">
                <p class="text-muted">User activity tracking is not implemented yet. This section would show login history, page views, etc.</p>
            </div>
        </div>
    </div>
</div>

<!-- Reset Password Modal -->
<div class="modal fade" id="resetPasswordModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Reset Password</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to reset the password for user <strong><?php echo sanitize($user['username']); ?></strong>?</p>
                <p>A new random password will be generated.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form method="POST" action="users.php">
                    <input type="hidden" name="action" value="reset_password">
                    <input type="hidden" name="user_id" value="<?php echo $user['id']; ?>">
                    <button type="submit" class="btn btn-warning">Reset Password</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Delete User Modal -->
<div class="modal fade" id="deleteUserModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Delete User</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete user <strong><?php echo sanitize($user['username']); ?></strong>?</p>
                <p class="text-danger">This action cannot be undone and will delete all books and links associated with this user.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form method="POST" action="users.php">
                    <input type="hidden" name="action" value="delete">
                    <input type="hidden" name="user_id" value="<?php echo $user['id']; ?>">
                    <button type="submit" class="btn btn-danger">Delete User</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include 'templates/footer.php'; ?>