<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo sanitize($book['title']); ?> - BookLinks</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            background-color: <?php echo $book['background_color']; ?>;
            color: <?php echo $book['text_color']; ?>;
            font-family: 'Arial', sans-serif;
        }
        .book-cover {
            max-width: 100%;
            height: auto;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }
        .book-links .btn {
            display: block;
            margin-bottom: 10px;
            background-color: <?php echo $book['button_color']; ?>;
            color: <?php echo $book['button_text_color']; ?>;
            border: none;
            padding: 12px;
            border-radius: 8px;
            transition: transform 0.2s;
        }
        .book-links .btn:hover {
            transform: translateY(-2px);
            opacity: 0.9;
        }
        .social-links {
            margin-top: 20px;
        }
        .social-links a {
            color: <?php echo $book['text_color']; ?>;
            font-size: 24px;
            margin: 0 10px;
            transition: transform 0.2s;
        }
        .social-links a:hover {
            transform: scale(1.2);
        }
        .container {
            max-width: 800px;
            padding: 30px 15px;
        }
        .section-title {
            font-size: 1.2rem;
            font-weight: bold;
            margin-top: 20px;
            margin-bottom: 15px;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-4 text-center mb-4">
                <?php if (!empty($book['cover_image'])): ?>
                    <img src="<?php echo UPLOAD_URL . $book['cover_image']; ?>" alt="<?php echo sanitize($book['title']); ?>" class="book-cover">
                <?php else: ?>
                    <div class="book-cover bg-secondary p-5 text-white d-flex align-items-center justify-content-center">
                        <div>No Cover Image</div>
                    </div>
                <?php endif; ?>
            </div>
            
            <div class="col-md-8">
                <h1 class="text-center mb-3"><?php echo sanitize($book['title']); ?></h1>
                
                <?php if (!empty($book['description'])): ?>
                    <div class="book-description mb-4">
                        <?php echo nl2br(sanitize($book['description'])); ?>
                    </div>
                <?php endif; ?>
                
                <div class="book-links">
                    <?php 
                    // Group buttons by type
                    $buttonGroups = [];
                    foreach ($buttons as $button) {
                        $type = $button['button_type'];
                        if (!isset($buttonGroups[$type])) {
                            $buttonGroups[$type] = [];
                        }
                        $buttonGroups[$type][] = $button;
                    }
                    
                    // Display buttons by group
                    foreach ($buttonGroups as $type => $groupButtons): 
                    ?>
                        <div class="section-title"><?php echo ucfirst(sanitize($type)); ?></div>
                        <?php foreach ($groupButtons as $button): 
                            // Create tracking link
                            $trackData = [
                                'type' => 'link',
                                'id' => $button['id'],
                                'book_id' => $book['id'],
                                'user_id' => $user['id'],
                                'url' => $button['url']
                            ];
                            $trackingUrl = APP_URL . '/index.php?track=' . base64_encode(json_encode($trackData));
                        ?>
                            <a href="<?php echo $trackingUrl; ?>" target="_blank" class="btn btn-lg btn-block">
                                <?php echo sanitize($button['label']); ?>
                            </a>
                        <?php endforeach; ?>
                    <?php endforeach; ?>
                </div>
                
                <?php if (!empty($socialLinks)): ?>
                    <div class="social-links text-center">
                        <?php foreach ($socialLinks as $social): ?>
                            <a href="<?php echo sanitize($social['url']); ?>" target="_blank" title="<?php echo ucfirst(sanitize($social['platform'])); ?>">
                                <i class="fab fa-<?php echo sanitize($social['platform']); ?>"></i>
                            </a>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="text-center mt-5">
            <small>Powered by <a href="<?php echo APP_URL; ?>" style="color: <?php echo $book['text_color']; ?>;">BookLinks</a></small>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>